/*
 * Decompiled with CFR 0.152.
 */
package jimena.solver;

import java.util.ArrayList;

public class Node {
    private String name = "NodeRich";
    private Integer id;
    private ArrayList<Integer> inhBy = new ArrayList();
    private ArrayList<Integer> actBy = new ArrayList();
    private ArrayList<Integer> act = new ArrayList();
    private ArrayList<Integer> inh = new ArrayList();

    public Node() {
    }

    public Node(Integer nodeID) {
        this();
        this.setID(nodeID);
    }

    public Node(Integer nodeID, String nodeLabel) {
        this();
        this.setID(nodeID);
        this.setName(nodeLabel);
    }

    public boolean equals(Node o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.getID() == o.getID();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name.equals(name)) {
            return;
        }
        this.name = name;
    }

    public void setID(Integer id) {
        this.id = id;
    }

    public Integer getID() {
        return this.id;
    }

    public void addInhBy(Integer n) {
        this.inhBy.add(n);
    }

    public void addActBy(Integer n) {
        this.actBy.add(n);
    }

    public ArrayList<Integer> getInhBy() {
        return this.inhBy;
    }

    public ArrayList<Integer> getActBy() {
        return this.actBy;
    }

    public void addAct(Integer n) {
        this.act.add(n);
    }

    public void addInh(Integer n) {
        this.inh.add(n);
    }

    public ArrayList<Integer> getAct() {
        return this.act;
    }

    public ArrayList<Integer> getInh() {
        return this.inh;
    }

    public int countEdges() {
        return this.act.size() + this.inh.size();
    }

    public int countByEdges() {
        return this.actBy.size() + this.inhBy.size();
    }

    public String toString() {
        return "(" + this.getID() + ") " + this.getName();
    }
}

