/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import jimena.simulation.CalculationController;

public class BasicCalculationController
implements CalculationController {
    private long lastStatusMessage = System.currentTimeMillis();
    private static final long statusMessageInterval = 1000L;
    private static final NumberFormat percentageFormatter = new DecimalFormat("##0.0#########");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public BasicCalculationController() {
        Date date = new Date();
        System.out.println("Calculation started at " + dateFormat.format(date) + ".");
    }

    @Override
    public void setProgress(double progress, int stepsDone) {
        if (System.currentTimeMillis() - this.lastStatusMessage >= 1000L) {
            System.out.println("Progress: " + percentageFormatter.format(progress * 100.0) + "%, steps done: " + stepsDone);
            this.lastStatusMessage = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isOn() {
        return true;
    }

    @Override
    public void notifyCalculationFinished() {
        Date date = new Date();
        System.out.println("Calculation finished at " + dateFormat.format(date));
    }

    @Override
    public void setProgress(int stepsDone, int maxSteps) {
        this.setProgress((double)stepsDone / (double)maxSteps, stepsDone);
    }
}

