/*
 * Decompiled with CFR 0.152.
 */
package jimena.ssssearcher;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.SSSSearchParameters;
import jimena.simulation.SSSFromStartVector;
import jimena.ssssearcher.SSSSearchResult;

public abstract class SSSSearcher {
    public abstract SSSSearchResult searchSSStates(RegulatoryNetwork var1, SSSSearchParameters var2, long var3);

    public abstract SSSSearchResult searchSSStates(RegulatoryNetwork var1, long var2, SSSSearchParameters var4);

    protected static ArrayList<double[]> executeSearch(RegulatoryNetwork network, SSSSearchParameters p, ArrayList<double[]> startVectors, long maxTime) {
        ArrayList<double[]> results = new ArrayList<double[]>();
        long start = System.currentTimeMillis();
        ArrayList<double[]> realStartVectors = new ArrayList<double[]>();
        for (double[] vector : startVectors) {
            realStartVectors.add(vector);
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(p.getThreads());
        SSSFromStartVector[] searchers = new SSSFromStartVector[realStartVectors.size()];
        int i = 0;
        while (i < realStartVectors.size()) {
            searchers[i] = network.stableSteadyStateSearcher((double[])realStartVectors.get(i), p.getStabilityMaxDiff(), p.getStabilityMinTime(), p.getMethod(), p.getDt(), p.getMaxT(), null);
            threadPool.submit(searchers[i]);
            ++i;
        }
        threadPool.shutdown();
        try {
            while (System.currentTimeMillis() - start <= maxTime && !threadPool.isTerminated()) {
                threadPool.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Interrupted.");
        }
        i = 0;
        while (i < searchers.length) {
            if (searchers[i].getResult() != null) {
                results.add(searchers[i].getResult());
            }
            ++i;
        }
        return results;
    }

    protected void addWithoutDuplicates(SSSSearchResult searchResult, ArrayList<double[]> newItems, double duplicateMaxDiff, boolean count) {
        for (double[] newItem : newItems) {
            this.addDuplicateFree(searchResult, newItem, duplicateMaxDiff, count);
        }
    }

    protected void addDuplicateFree(SSSSearchResult searchResult, double[] newItem, double duplicateMaxDiff, boolean count) {
        int j = 0;
        while (j < searchResult.getResults().size()) {
            double[] oldItem = searchResult.getResults().get(j);
            boolean isIdentical = true;
            int i = 0;
            while (i < newItem.length) {
                if (Math.abs(newItem[i] - oldItem[i]) > duplicateMaxDiff) {
                    isIdentical = false;
                    break;
                }
                ++i;
            }
            if (isIdentical && count) {
                searchResult.getCounter().set(j, searchResult.getCounter().get(j) + 1);
                return;
            }
            ++j;
        }
        if (count) {
            searchResult.getCounter().add(1);
        } else {
            searchResult.getCounter().add(0);
        }
        searchResult.getResults().add(newItem);
    }
}

