/*
 * Decompiled with CFR 0.152.
 */
package jimena.perturbation;

import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.perturbation.Perturbation;
import jimena.perturbation.RealValuesPerturbation;

public class RandomPerturbation
extends RealValuesPerturbation {
    private DoubleValue start;
    private DoubleValue end;
    private DoubleValue min;
    private DoubleValue max;
    private static final String[] valueNames = new String[]{"Start", "End", "Minimum", "Maximum"};

    private RandomPerturbation(DoubleValue start, DoubleValue end, DoubleValue min, DoubleValue max) {
        super(new DoubleValue[]{start, end, min, max}, valueNames);
        this.start = start;
        this.end = end;
        this.min = min;
        this.max = max;
    }

    public RandomPerturbation(double start, double end, double min, double max) {
        this(new DoubleValue(MathLib.isNotNaN(start) ? start : 0.0), new DoubleValue(MathLib.isNotNaN(end) ? end : 1000.0), new DoubleValue(MathLib.isNotNaN(min) ? min : 0.0, 0.0, 1.0), new DoubleValue(MathLib.isNotNaN(max) ? max : 1.0, 0.0, 1.0));
    }

    public RandomPerturbation(double onset, double min, double max) {
        this(onset, Double.NaN, min, max);
    }

    public RandomPerturbation(double min, double max) {
        this(Double.NaN, Double.NaN, min, max);
    }

    public RandomPerturbation(double onset) {
        this(onset, Double.NaN, Double.NaN, Double.NaN);
    }

    public RandomPerturbation() {
        this(0.0);
    }

    @Override
    public double getValue(double t) {
        if (t >= this.start.getValue() && t <= this.end.getValue()) {
            double value = Math.random();
            return this.min.getValue() + value * (this.max.getValue() - this.min.getValue());
        }
        return -1.0;
    }

    @Override
    public String getDescription() {
        return "Random value between " + this.min + " and " + this.max + " from " + this.start + " to " + this.end;
    }

    public String toString() {
        return "Random Perturbation";
    }

    @Override
    public Perturbation clone() {
        return new RandomPerturbation(this.start.getValue(), this.end.getValue(), this.min.getValue(), this.max.getValue());
    }
}

