/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.guilib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import jimena.gui.guilib.DataTableModel;
import jimena.libs.StringLib;
import jimena.libs.TxtFileChooser;

public class TableFrame
extends JDialog {
    private static final long serialVersionUID = 6543306651498035545L;
    private JTable table = null;
    private ArrayList<Object[]> data = null;
    private String[] titles = null;

    public TableFrame(JFrame parent, String title, ArrayList<Object[]> data, String[] titles, Class<?> type, String[] horizontal) {
        super(parent, title, true);
        this.data = data;
        this.titles = titles;
        this.getContentPane().setLayout(new BorderLayout());
        this.table = new JTable(new DataTableModel(data, titles, type, horizontal)){
            private static final long serialVersionUID = -7707184520358542400L;
            {
                KeyListener[] keyListenerArray = this.getKeyListeners();
                int n = keyListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyListener listener = keyListenerArray[n2];
                    this.removeKeyListener(listener);
                    ++n2;
                }
                this.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 83 && e.isControlDown()) {
                            ArrayList<Object[]> exportData = new ArrayList<Object[]>();
                            int[] nArray = TableFrame.this.table.getSelectedRows();
                            int n = nArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int i = nArray[n2];
                                exportData.add((Object[])TableFrame.this.data.get(i));
                                ++n2;
                            }
                            String export = StringLib.arrayToCommaSeparatedUnchecked(exportData);
                            TxtFileChooser.writeToTextFile(export, TableFrame.this);
                        }
                    }
                });
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        DefaultTableColumnModel columnModel = (DefaultTableColumnModel)this.table.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            columnModel.getColumn(i).setPreferredWidth(50);
            ++i;
        }
        this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()){
            private static final long serialVersionUID = -8257137320637006229L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int i = TableFrame.this.table.getColumnModel().getColumnIndexAtX(e.getX());
                return TableFrame.this.titles[i];
            }
        });
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setToolTipText("Select several row using the shift and control keys and save the values to a csv file by pressing Ctrl + [S].");
        this.table.setDefaultRenderer(Double.class, new FractionCellRenderer(5));
        this.getContentPane().add((Component)new JScrollPane(this.table), "Center");
        JButton closeButton = new JButton("Close Window");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableFrame.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)closeButton, "South");
        this.pack();
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setDefaultCloseOperation(2);
    }

    class FractionCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4206747185037314310L;
        private final int fraction;
        private final NumberFormat formatter = NumberFormat.getInstance();

        public FractionCellRenderer(int fraction) {
            this.fraction = fraction;
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException("This rendere only works with doubles.");
            }
            this.formatter.setMaximumFractionDigits(this.fraction);
            this.setText(this.formatter.format(((Number)value).doubleValue()));
        }
    }
}

