/*
 * Decompiled with CFR 0.152.
 */
package jimena.calculationparameters;

import jimena.calculationparameters.SSSSimulationParameters;
import jimena.simulation.CalculationController;
import jimena.simulationmethods.SimulationMethod;

public class SSSSearchParameters
extends SSSSimulationParameters {
    private int threads;
    private double duplicateMaxDiff;

    public SSSSearchParameters(SimulationMethod method, double dt, double maxT, CalculationController calculationController, double stabilityMaxDiff, double stabilityMinTime, int threads, double duplicateMaxDiff) {
        super(method, dt, maxT, calculationController, stabilityMaxDiff, stabilityMinTime);
        this.setThreads(threads);
        this.setDuplicateMaxDiff(duplicateMaxDiff);
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("The number of threads must be greaten than 0.");
        }
        this.threads = threads;
    }

    public double getDuplicateMaxDiff() {
        return this.duplicateMaxDiff;
    }

    public void setDuplicateMaxDiff(double duplicateMaxDiff) {
        if (duplicateMaxDiff < 2.0 * this.getStabilityMaxDiff()) {
            throw new IllegalArgumentException("The maximum difference for two components to be considered equal may not be less then 2 times the stabilityMinDiff.");
        }
        this.duplicateMaxDiff = duplicateMaxDiff;
    }
}

