/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf;

import java.io.Serializable;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public abstract class BinaryBooleanFunction
implements Serializable {
    private static final long serialVersionUID = 1157583500831313750L;

    public abstract boolean eval(boolean[] var1);

    public BDD createBDD(BDD[] inputs, BDDFactory bddFactory) {
        if (inputs == null) {
            throw new NullPointerException();
        }
        if (this.getArity() != inputs.length) {
            throw new IllegalArgumentException("Number of inputs must correspond to arity of the function.");
        }
        BDD[] bDDArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            BDD input = bDDArray[n2];
            if (input == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
        if (bddFactory == null) {
            throw new NullPointerException();
        }
        return this.createBDDUnchecked(inputs, bddFactory);
    }

    protected abstract BDD createBDDUnchecked(BDD[] var1, BDDFactory var2);

    public abstract int getArity();

    public abstract double interpolateSQUAD(double[] var1, double[] var2) throws InterpolationMethodNotSupported;

    public double interpolateBooleOrHillCube(double[] inputs, boolean hill, boolean hillNormalize, double[] hillNs, double[] hillKs) {
        return this.interpolateBooleCube(hill ? this.hill(inputs, hillNormalize, hillNs, hillKs) : inputs);
    }

    protected abstract double interpolateBooleCube(double[] var1);

    protected double[] hill(double[] inputs, boolean hillNormalize, double[] hillNs, double[] hillKs) {
        double[] result = new double[inputs.length];
        int i = 0;
        while (i < inputs.length) {
            double n = hillNs[i];
            double k = hillKs[i];
            double xn = Math.pow(inputs[i], n);
            double kn = Math.pow(k, n);
            result[i] = xn / (xn + kn);
            if (hillNormalize) {
                int n2 = i;
                result[n2] = result[n2] / (1.0 / (1.0 + kn));
            }
            ++i;
        }
        return result;
    }

    public abstract BinaryBooleanFunction clone();

    public abstract String toString();

    public abstract void disableInput(int var1);

    public abstract void restore();

    public abstract String getFunctionString(String[] var1, boolean var2);

    public class InterpolationMethodNotSupported
    extends RuntimeException {
        private static final long serialVersionUID = -4202385161308792480L;

        public InterpolationMethodNotSupported() {
            super("Your model contains a node that cannot be simulated with the specified interpolation method.\nPlease choose a universal method like BooleCube or HillCube interpolation.");
        }
    }
}

