/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.ContinuousSimulationMethod;

public class HillCubeMethod
extends ContinuousSimulationMethod {
    @Override
    public double getDerivativeValue(RegulatoryNetwork network, int nodeIndex, double[] values) {
        NetworkNode node = network.getNetworkNodes()[nodeIndex];
        BinaryBooleanFunction function = node.getFunction();
        double interpol = function.interpolateBooleOrHillCube(this.getInputs(network, nodeIndex, values), true, false, node.getHillNs(), node.getHillKs());
        return (interpol - values[nodeIndex]) / network.getNetworkNodes()[nodeIndex].getOdefyDecay();
    }

    @Override
    public String toString() {
        return "HillCube";
    }
}

