/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import javax.swing.JOptionPane;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.SimulationParameters;
import jimena.libs.ChecksLib;
import jimena.simulation.CalculationController;
import jimena.simulationmethods.SimulationMethod;

public class Simulator
extends Thread {
    private double minSimulationTimeBetweenLogs;
    private static final double minTimeBetweenNotifications = 50.0;
    private RegulatoryNetwork network;
    private SimulationMethod method;
    private double dt;
    private double maxt;
    private double maxSpeed;
    private CalculationController calculationController;

    public Simulator(SimulationParameters parameters, RegulatoryNetwork network, double maxSpeed, double minSimulationTimeBetweenLogs) {
        ChecksLib.checkNotNull(network, parameters.getMethod());
        if (parameters.getDt() <= 0.0 || parameters.getMaxT() < 0.0 || maxSpeed <= 0.0 || minSimulationTimeBetweenLogs <= 0.0) {
            throw new IllegalArgumentException("All numerical inputs to the constuctor of a Simulator must positive.");
        }
        this.network = network;
        this.method = parameters.getMethod();
        this.dt = parameters.getDt();
        this.maxt = parameters.getMaxT();
        this.maxSpeed = maxSpeed;
        this.minSimulationTimeBetweenLogs = minSimulationTimeBetweenLogs;
        this.calculationController = parameters.getCalculationController();
    }

    @Override
    public void run() {
        if (this.network.nodeCount() != 0) {
            try {
                double t = 0.0;
                long lastNotification = System.currentTimeMillis();
                int stepsDone = 0;
                int stepsPerLap = (int)(this.maxSpeed * 50.0 / this.dt / 1000.0);
                int stepsDoneAtLastNotification = 0;
                double timeIndexAtLastLog = 0.0;
                while (t + this.dt < this.maxt + this.dt / 10.0 && (this.calculationController == null || this.calculationController.isOn())) {
                    if (stepsDone - stepsDoneAtLastNotification <= stepsPerLap) {
                        this.method.stepUpdateNetwork(this.network, this.dt);
                        t += this.dt;
                        ++stepsDone;
                    } else {
                        Thread.sleep(1L);
                    }
                    if ((double)(System.currentTimeMillis() - lastNotification) >= 50.0) {
                        stepsDoneAtLastNotification = stepsDone;
                        if (this.calculationController != null) {
                            this.calculationController.setProgress(t / this.maxt, stepsDone);
                        }
                        this.network.notifyObserversOfChangedValues();
                        lastNotification = System.currentTimeMillis();
                    }
                    if (!(this.network.getTimeIndex().getValue() - timeIndexAtLastLog >= this.minSimulationTimeBetweenLogs)) continue;
                    this.network.log();
                    timeIndexAtLastLog = this.network.getTimeIndex().getValue();
                }
                this.network.notifyObserversOfChangedValues();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Simulation failed", 0);
            }
            if (this.calculationController != null) {
                this.calculationController.notifyCalculationFinished();
            }
        }
    }
}

