/*
 * Decompiled with CFR 0.152.
 */
package jimena.libs;

import java.util.List;
import java.util.Set;
import jimena.libs.MathLib;

public class SSSLib {
    public static double setDifference(List<double[]> set1, List<double[]> set2, Set<Integer> componentsToConsider) {
        if (set1.size() == 0 || set2.size() == 0) {
            return 1.0;
        }
        for (double[] s : set1) {
            if (set1.get(0).length == s.length) continue;
            throw new IllegalArgumentException("All members of both sets have to have the same size.");
        }
        for (double[] s : set1) {
            if (set2.get(0).length == s.length) continue;
            throw new IllegalArgumentException("All members of both sets have to have the same size.");
        }
        return (SSSLib.setDifferenceUnidirectionalUnchecked(set1, set2, componentsToConsider) + SSSLib.setDifferenceUnidirectionalUnchecked(set2, set1, componentsToConsider)) / 2.0;
    }

    public static double[] setDifferenceSingle(List<double[]> set1, List<double[]> set2) {
        if (set1.size() == 0 || set2.size() == 0) {
            throw new IllegalArgumentException("The difference is not defined if one of the sets has no members.");
        }
        for (double[] s : set1) {
            if (set1.get(0).length == s.length) continue;
            throw new IllegalArgumentException("All members of both sets have to have the same size.");
        }
        for (double[] s : set1) {
            if (set2.get(0).length == s.length) continue;
            throw new IllegalArgumentException("All members of both sets have to have the same size.");
        }
        double[] result = SSSLib.setDifferenceUnidirectionalSingleUnchecked(set1, set2);
        MathLib.addDoubleArraysUnchecked(result, SSSLib.setDifferenceUnidirectionalSingleUnchecked(set2, set1));
        MathLib.divideDoubleArraysUnchecked(result, 2.0);
        return result;
    }

    public static double byteSetDifference(List<byte[]> set1, List<byte[]> set2, Set<Integer> componentsToConsider) {
        return SSSLib.setDifference(MathLib.byteArrayListToDoubleArrayListUnchecked(set1), MathLib.byteArrayListToDoubleArrayListUnchecked(set2), componentsToConsider);
    }

    public static double[] byteSetDifferenceSingle(List<byte[]> set1, List<byte[]> set2) {
        return SSSLib.setDifferenceSingle(MathLib.byteArrayListToDoubleArrayListUnchecked(set1), MathLib.byteArrayListToDoubleArrayListUnchecked(set2));
    }

    private static double setDifferenceUnidirectionalUnchecked(List<double[]> set1, List<double[]> set2, Set<Integer> componentsToConsider) {
        double result = 0.0;
        for (double[] member : set1) {
            result += SSSLib.mostSimilarDifferenceUnchecked(set2, member, componentsToConsider);
        }
        return result / (double)set1.size();
    }

    private static double[] setDifferenceUnidirectionalSingleUnchecked(List<double[]> set1, List<double[]> set2) {
        double[] anElement = MathLib.randomElement(set1, set2);
        if (set1.size() == 0) {
            return null;
        }
        double[] result = new double[anElement.length];
        for (double[] member : set1) {
            MathLib.addDoubleArraysUnchecked(result, SSSLib.mostSimilarDifferenceUncheckedSingle(set2, member));
        }
        MathLib.divideDoubleArraysUnchecked(result, set1.size());
        return result;
    }

    private static double mostSimilarDifferenceUnchecked(List<double[]> haystack, double[] needle, Set<Integer> componentsToConsider) {
        double minDifference = Double.MAX_VALUE;
        for (double[] candidate : haystack) {
            double difference = MathLib.meanSquaredDifferenceUnchecked(candidate, needle, componentsToConsider);
            if (!(minDifference > difference)) continue;
            minDifference = difference;
        }
        return minDifference;
    }

    private static double[] mostSimilarDifferenceUncheckedSingle(List<double[]> haystack, double[] needle) {
        double minDifference = Double.MAX_VALUE;
        double[] result = new double[needle.length];
        for (double[] candidate : haystack) {
            double difference = MathLib.meanSquaredDifferenceUnchecked(candidate, needle);
            if (!(minDifference > MathLib.meanSquaredDifferenceUnchecked(candidate, needle))) continue;
            minDifference = difference;
            result = MathLib.squaredDifferenceUnchecked(candidate, needle);
        }
        return result;
    }
}

