/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import java.util.ArrayList;
import java.util.Collections;
import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.DiscreteSimulationMethod;

public class DARBNInterpolationMethod
extends DiscreteSimulationMethod {
    private static ArrayList<Integer> order;

    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        if (order == null || order.size() != network.nodeCount()) {
            ArrayList<Integer> order = new ArrayList<Integer>();
            int i = 0;
            while (i < network.nodeCount()) {
                order.add(i);
                ++i;
            }
            Collections.shuffle(order);
        }
        int i = 0;
        while (i < order.size()) {
            NetworkNode node;
            BinaryBooleanFunction function = (node = network.getNetworkNodes()[order.get(i)]).getFunction();
            node.setValue(function.eval(this.getBooleanInputs(network, i)) ? 1.0 : 0.0);
            ++i;
        }
    }

    @Override
    public String toString() {
        return "DARBN";
    }
}

