/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.SimulationMethod;

public abstract class ContinuousSimulationMethod
extends SimulationMethod {
    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        double[] k1 = new double[network.nodeCount()];
        double[] k2 = new double[network.nodeCount()];
        double[] k3 = new double[network.nodeCount()];
        double[] k4 = new double[network.nodeCount()];
        double[] results = new double[network.nodeCount()];
        int i = 0;
        while (i < network.nodeCount()) {
            k1[i] = this.getDerivativeValue(network, i, network.getValues());
            results[i] = k1[i] * dt / 2.0 + network.getNetworkNodes()[i].getValue();
            ++i;
        }
        i = 0;
        while (i < network.nodeCount()) {
            k2[i] = this.getDerivativeValue(network, i, results);
            results[i] = k2[i] * dt / 2.0 + network.getNetworkNodes()[i].getValue();
            ++i;
        }
        i = 0;
        while (i < network.nodeCount()) {
            k3[i] = this.getDerivativeValue(network, i, results);
            results[i] = k3[i] * dt + network.getNetworkNodes()[i].getValue();
            ++i;
        }
        i = 0;
        while (i < network.nodeCount()) {
            k4[i] = this.getDerivativeValue(network, i, results);
            results[i] = (k1[i] + 2.0 * k2[i] + 2.0 * k3[i] + k4[i]) / 6.0 * dt + network.getNetworkNodes()[i].getValue();
            network.getNetworkNodes()[i].setValue(results[i]);
            ++i;
        }
    }

    public abstract double getDerivativeValue(RegulatoryNetwork var1, int var2, double[] var3);
}

