/*
 * Decompiled with CFR 0.152.
 */
package jimena.perturbation;

import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.perturbation.Perturbation;
import jimena.perturbation.RealValuesPerturbation;

public class OnOffPerturbation
extends RealValuesPerturbation {
    private static final long serialVersionUID = -2434774668601149565L;
    private DoubleValue start;
    private DoubleValue end;
    private DoubleValue value;
    private static final String[] valueNames = new String[]{"Start", "End", "Value"};

    private OnOffPerturbation(DoubleValue start, DoubleValue end, DoubleValue value) {
        super(new DoubleValue[]{start, end, value}, valueNames);
        this.start = start;
        this.end = end;
        this.value = value;
    }

    public OnOffPerturbation(double start, double end, double value) {
        this(new DoubleValue(MathLib.isNotNaN(start) ? start : 0.0), new DoubleValue(MathLib.isNotNaN(end) ? end : 1000.0), new DoubleValue(MathLib.isNotNaN(value) ? value : 1.0, 0.0, 1.0));
    }

    public OnOffPerturbation(double start, double value) {
        this(start, Double.NaN, value);
    }

    public OnOffPerturbation(double value) {
        this(Double.NaN, Double.NaN, value);
    }

    public OnOffPerturbation() {
        this(Double.NaN, Double.NaN, Double.NaN);
    }

    @Override
    public double getValue(double t) {
        return t >= this.start.getValue() && t <= this.end.getValue() ? this.value.getValue() : -1.0;
    }

    @Override
    public String getDescription() {
        return "Value " + this.value + " from " + this.start + " to " + this.end;
    }

    @Override
    public String toString() {
        return "On-Off-Perturbation";
    }

    @Override
    public Perturbation clone() {
        return new OnOffPerturbation(this.start.getValue(), this.end.getValue(), this.value.getValue());
    }
}

