clear all;
close all;

cd SMA

%% read in metadata
[num,txt,raw]=xlsread('data.xls');
p=cell2struct(raw(2:25,1:9),raw(1,1:9),2);

%% load analyzed data
 
 d = struct('scale',0.2*ones(1,24));

for i=1:24
    
    oldpath = pwd;
    
    cd(p(i).dir);
    
    dirname = sprintf('%03d',p(i).folder);
    cd(dirname);       
    
    load r
           
    d(i).a = r.a;
    d(i).b = r.b; 
    
    d(i).d_bins = r.d_bins;
    d(i).sma_fib = r.sma_fib;
    d(i).sma_bg = r.sma_bg;            

    d(i).id = ceil(i/8);
    
    if(d(i).id==1)
        d(i).idclr = [.7,.1,.1];
        d(i).linespec = 'v';
    end;
    if(d(i).id==2)
        d(i).idclr = [1,.5,.3];
        d(i).linespec = '^';
    end;
    if(d(i).id==3)
        d(i).idclr = [0,0,.4];
        d(i).linespec = 'o';
    end;
    
    cd(oldpath)
end;

cd ..

%% aSMA on surface

f1=figure('Position',[100 100 250 400]);
plot_x(log10([d.a]),d);
box on;
axis([-0.5 2.5 0 2]);
set(gca,'XTick',[0 1 2]);
set(gca,'YTick',[0 1 2]);
set(gca,'XTickLabel',{'Ctrl\newline(n=8)','Bleb\newline(n=8)','TGF\beta\newline(n=8)'});
set(gca,'YTickLabel',{'10^0','10^1','10^2'});
yl=ylabel('\alphaSMA on surface');
set(gcf,'PaperPositionMode','auto')
set(gca,'LineWidth',2);
set(gca,'FontSize',14);
set(yl,'FontSize',18);

%% aSMA ratio

f1=figure('Position',[100 100 250 400]);
plot_x([d.a]./[d.b],d);
box on;
axis([-0.5 2.5 0 75]);
set(gca,'XTick',[0 1 2]);
set(gca,'XTickLabel',{'Ctrl\newline(n=8)','Bleb\newline(n=8)','TGF\beta\newline(n=8)'});
yl=ylabel('\alphaSMA {\it(surface/interior)}');%,'interpreter','latex');
set(gcf,'PaperPositionMode','auto')
set(gca,'LineWidth',2);
set(gca,'FontSize',14);
set(yl,'FontSize',18);


%% aSMA normalized over distance

e=[];
da=[];
for i=1:24
    for j=1:length(d(i).sma_fib)
        e(i,j)=d(i).sma_fib(j);
        da(i,j)=d(i).sma_bg(j);
    end;
end;

figure1=figure('Color',[1 1 1],'Position',[100 100 450 400]);

db = [0 d(1).d_bins(1:20)'];

dat=mean(e(1:8,1:21)./da(1:8,1:21),1);
serr=1/sqrt(8)*std(e(1:8,1:21)./da(1:8,1:21),1);
plot(db,dat,'-','Color',d(1).idclr,'LineWidth',1);
hold on;
h1=errorbar(db,dat,serr,'k^','LineWidth',1,'MarkerFaceColor',d(1).idclr,'MarkerSize',8);

dat=mean(e(9:16,1:21)./da(9:16,1:21),1);
serr=1/sqrt(8)*std(e(9:16,1:21)./da(9:16,1:21),1);
plot(db,dat,'-','Color',d(9).idclr,'LineWidth',1);
h2=errorbar(db,dat,serr,'kv','LineWidth',1,'MarkerFaceColor',d(9).idclr,'MarkerSize',8);

dat=mean(e(17:24,1:21)./da(17:24,1:21),1);
serr=1/sqrt(8)*std(e(17:24,1:21)./da(17:24,1:21),1);
plot(db,dat,'-','Color',d(17).idclr,'LineWidth',1);
h3=errorbar(db,dat,serr,'ko','LineWidth',1,'MarkerFaceColor',d(17).idclr,'MarkerSize',8);

l=legend([h1 h2 h3],'Ctrl (n=8)','Bleb (n=8)','TGF\beta (n=8)','Location','East');
set(l,'LineWidth',1,'FontSize',12);
set(l,'Position',[0.7 0.55 0.1 0.1]);

set(gca,'LineWidth',2);
set(gca,'FontSize',16);
xlabel('Distance to Growth Front (\mum)');
ylabel('\alphaSMA normalized');
set(gca,'TickLength',[0.03 0.01]);
set(gcf,'PaperPositionMode','auto')

set(gca,'YScale','log');

axis([0 40 0.1 30]);

% Create arrow
annotation(figure1,'arrow',[0.38 0.78],[0.78 0.78],...
    'Color',[0.3 0.3 0.3],...
    'LineWidth',2);

% Create textbox
annotation(figure1,'textbox',...
    [0.21 0.8 0.133 0.067],...
    'Color',[0.3 0.3 0.3],...
    'String',{'3 days'},...
    'LineStyle','none',...
    'FontAngle','italic');

% Create textbox
annotation(figure1,'textbox',...
    [0.46 0.8 0.148 0.067],...
    'Color',[0.313725490196078 0.313725490196078 0.313725490196078],...
    'String',{'7 days'},...
    'LineStyle','none',...
    'FontAngle','italic');

% Create textbox
annotation(figure1,'textbox',...
    [0.7 0.8 0.166 0.067],...
    'Color',[0.3 0.3 0.3],...
    'String','11 days',...
    'LineStyle','none',...
    'FontAngle','italic',...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.43 0.7 0.32 0.08],...
    'Color',[0.3 0.3 0.3],...
    'String',{'tissue maturity'},...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FontSize',12,...
    'FontAngle','italic',...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.335 0.865 0.566 0.058],...
    'String','                      interior',...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FitBoxToText','off',...
    'BackgroundColor',[0.95 0.95 0.85]);

% Create textbox
annotation(figure1,'textbox',...
    [0.18 0.865 0.18 0.058],...
    'String',{'surface'},...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FitBoxToText','off',...
    'BackgroundColor',[0.8 0.9 0.85]);

annotation(figure1,'line',[0.358 0.358],[0.91 0.15],'LineStyle','--');






