clear all;
close all;

cd FRET

%% load metadata
[num,txt,raw]=xlsread('fret.xls');
p=cell2struct(raw(2:end,:),raw(1,:),2);

%% load experiments
for i=1:27
    oldpath = pwd;
    
    % go to subdir and load data
    cd(p(i).dir);
    dirname = strsplit(p(i).filename,'.');
    cd(dirname{1});       
    load r    
    
    % write results into array d
    d(i).d_bins = r.d_bins;
    d(i).fret = r.fret;
    d(i).fret_m = r.fret_m;
    d(i).bins = r.bins;
    d(i).f = r.f;

    d(i).a = r.a;
    d(i).b = r.b;
       
    % set experiment IDs
    if(i<10)
        d(i).id = 1;
    elseif(i<19)
        d(i).id = 2;
    elseif(i<28)
        d(i).id = 3;
    end
    
    % set marker style and color
    if(d(i).id==1)
        d(i).idclr = [0.7,0.1,0.1];
        d(i).linespec = 'v';
    end  
    if(d(i).id==2)
        d(i).idclr = [1,.5,.3];
        d(i).linespec = '^';
    end
    if(d(i).id==3)
        d(i).idclr = [0,0,.4];
        d(i).linespec = 'o';
    end
    
    cd(oldpath)
end

cd ..


%% MEDIAN FRET INTENSITY RATIO

f1=figure('Position',[100 100 250 400]);
plot_xf([d.f],d,0.45);
box on;
set(gca,'XTick',[0 1 2 ]);
set(gca,'XTickLabel',{'Ctrl\newline(n=9)','Bleb\newline(n=9)','TGF\beta\newline(n=9)'});
yl=ylabel('FN-FRET ratio {\it interior / surface}');
ylabel('Median FN-FRET ratio');
set(gcf,'PaperPositionMode','auto')
set(gca,'FontSize',14,'LineWidth',2,'FontName','Arial');
set(yl,'FontSize',18);
axis([-0.5 2.5 0.45 0.73])

%% FRET RATIO BULK/SURFACE

f1=figure('Position',[100 100 250 400]);
plot_xf([d.b]./[d.a],d,0.95);
box on;
set(gca,'XTick',[0 1 2 ]);
set(gca,'XTickLabel',{'Ctrl\newline(n=9)','Bleb\newline(n=9)','TGF\beta\newline(n=9)'});
yl=ylabel('FN-FRET {\it(interior/surface})');
set(gcf,'PaperPositionMode','auto')
set(gca,'FontSize',14,'LineWidth',2,'FontName','Arial');
set(yl,'FontSize',18);
axis([-0.5 2.5 0.95 1.12])
line([-0.5 2.5],[1 1],'LineStyle','--','Color',[0 0 0]);

%% FRET vs DISTANCE

figure1=figure('Color',[1 1 1],'Position',[100 100 450 400]);

e=[];
da=[];
for i=1:27
    for j=1:length(d(i).fret_m)
        e(i,j)=d(i).fret_m(j);
    end;
end;

db = [0 d(1).d_bins(1:20)'];

dat=mean(e(1:9,1:21),1);
serr=1/sqrt(9)*std(e(1:9,1:21),1);
plot(db,dat,'-','Color',d(1).idclr,'LineWidth',1);
hold on;
errorbar(db,dat,serr,'kv','LineWidth',1,'MarkerFaceColor',d(1).idclr,'MarkerSize',8);

dat=mean(e(10:18,1:21),1);
serr=1/sqrt(9)*std(e(10:18,1:21),1);
plot(db,dat,'-','Color',d(10).idclr,'LineWidth',1);
hold on;
errorbar(db,dat,serr,'k^','LineWidth',1,'MarkerFaceColor',d(10).idclr,'MarkerSize',8);

dat=mean(e(19:27,1:21),1);
serr=1/sqrt(10)*std(e(19:27,1:21),1);
plot(db,dat,'-','Color',d(19).idclr,'LineWidth',1);
hold on;
errorbar(db,dat,serr,'ko','LineWidth',1,'MarkerFaceColor',d(19).idclr,'MarkerSize',8);

set(gca,'LineWidth',2);
set(gca,'FontSize',16);
xlabel('Distance to Growth Front (\mum)');
ylabel('FN-FRET ratio');

set(gca,'TickLength',[0.03 0.01]);
set(gcf,'PaperPositionMode','auto')

axis([-0.1 60 0.46 0.68]);

% Create textbox
annotation(figure1,'textbox',...
    [0.185 0.8637 0.35 0.059],'String','    ',...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FitBoxToText','off',...
    'BackgroundColor',[0.8 0.9 0.85]);

% Create textbox
annotation(figure1,'textbox',...
    [0.31 0.8637 0.592 0.059],...
    'String','                      interior',...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FitBoxToText','off',...
    'BackgroundColor',[0.95 0.95 0.85]);

% Create textbox
annotation(figure1,'textbox',...
    [0.42 0.27 0.32 0.08],'Color',[0.3 0.3 0.3],...
    'String',{'tissue maturity'},...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FontSize',12,...
    'FontAngle','italic',...
    'FitBoxToText','off');

% Create arrow
annotation(figure1,'arrow',[0.36 0.76],...
    [0.27 0.27],'Color',[0.3 0.3 0.3],'LineWidth',2);

% Create textbox
annotation(figure1,'textbox',...
    [0.19 0.19 0.13 0.067],...
    'Color',[0.3 0.3 0.3],...
    'String','3 days',...
    'LineStyle','none',...
    'FontAngle','italic',...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.75 0.19 0.15 0.067],...
    'Color',[0.3 0.3 0.3],...
    'String','15 days',...
    'LineStyle','none',...
    'FontAngle','italic',...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.55 0.19 0.15 0.067],...
    'Color',[0.3 0.3 0.3],...
    'String','11 days',...
    'LineStyle','none',...
    'FontAngle','italic',...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.36 0.19 0.16 0.067],'Color',[0.3 0.3 0.3],...
    'String','7 days',...
    'LineStyle','none',...
    'FontAngle','italic',...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.18 0.867 0.18 0.058],...
    'String',{'surface'},...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FitBoxToText','off');

annotation(figure1,'line',[0.31 0.31],[0.92 0.13],'LineStyle','--');

annotation(figure1,'textbox',...
    [0.32 0.77 0.36 0.08],...
    'Color',d(10).idclr,...
    'String',{'Blebbistatin (n=9)'},...
    'FontWeight','bold',...
    'FontSize',12,...
    'EdgeColor','none');

% Create textbox
annotation(figure1,'textbox',...
    [0.65 0.38 0.26 0.08],...
    'Color',d(19).idclr,...
    'String',{'TGF-\beta (n=9)'},...
    'FontWeight','bold',...
    'FontSize',12,...
    'EdgeColor','none');

% Create textbox
annotation(figure1,'textbox',...
    [0.5 0.59 0.28 0.08],...
    'Color',d(1).idclr,...
    'String',{'Control (n=9)'},...
    'FontWeight','bold',...
    'FontSize',12,...
    'EdgeColor','none');

%% FRET HISTOGRAM

figure1=figure('Color',[1 1 1]);

f=zeros(length(d(1).fret),1);
f2=zeros(length(d(1).fret),1);
f3=zeros(length(d(1).fret),1);
for i=1:9
        f = f + d(i).fret;
end;
f=f./9;
for i=10:18
        f2 = f2 + d(i).fret;
end;
f2=f2./9;
for i=19:27
        f3 = f3 + d(i).fret;
end;
f3=f3./10;

minfret = 0.2;
maxfret = 1.0;
line0M = 0.75;
line1M = 0.55;
line4M = 0.42;
denat = [0.75 0.55 0.42];
cm = get_fret_cm(denat,minfret,maxfret);

ymax(1) = 1.2*max(f);
plot(d(1).bins,f,'-','Color',d(1).idclr,'LineWidth',3);hold on;

ymax(2) = 1.2*max(f2);
plot(d(10).bins,f2,'-','LineWidth',3,'Color',d(10).idclr);hold on;

ymax(3) = 1.2*max(f3);
plot(d(20).bins,f3,'-','LineWidth',3,'Color',d(20).idclr);hold on;

xlabel('FN-FRET ratio (I_a/I_d)');

ymax = max(ymax);

line([line0M line0M],[0 ymax],'LineWidth',2,'Color',[0.5 0.5 0.5]);
line([line1M line1M],[0 ymax],'LineWidth',2,'Color',[0.5 0.5 0.5]);
line([line4M line4M],[0 ymax],'LineWidth',2,'Color',[0.5 0.5 0.5]);
axis([minfret maxfret 0 ymax]);
colormap(cm);
colorbar('Location','SouthOutside','Color','none');
set(gca,'FontSize',16,'LineWidth',2);
xlabel('FN-FRET ratio (I_a/I_d)');
ylabel('Probability (%)');

box on;
set(gcf,'PaperPositionMode','auto');
set(gca,'OuterPosition',[0 -0.1 1 1]);

% Create textbox
annotation(figure1,'textbox',...
    [0.3 0.13 0.1 0.07],...
    'Color',[1 1 1],...
    'String',{'0.4'},...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FontName','Arial',...
    'FontSize',12);

% Create textbox
annotation(figure1,'textbox',...
    [0.68 0.13 0.1 0.07],...
    'Color',[1 1 1],...
    'String',{'0.8'},...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FontName','Arial',...
    'FontSize',12);

% Create textbox
annotation(figure1,'textbox',...
    [0.845 0.13 0.1 0.07],...
    'Color',[1 1 1],...
    'String',{'1.0'},...
    'EdgeColor','none',...
    'FontName','Arial',...
    'FontWeight','bold',...
    'FontSize',12);

% Create textbox
annotation(figure1,'textbox',...
    [0.122 0.13 0.1 0.07],...
    'Color',[1 1 1],...
    'String',{'0.2'},...
    'LineStyle','none',...
    'FontName','Arial',...
    'FontWeight','bold',...
    'FontSize',12);

% Create textbox
annotation(figure1,'textbox',...
    [0.48 0.13 0.1 0.07],...
    'String',{'0.6'},...
    'LineStyle','none',...
    'FontName','Arial',...
    'FontWeight','bold',...
    'FontSize',12);


% Create textbox
annotation(figure1,'textbox',...
    [0.63 0.85 0.07 0.06],...
    'Color',[0.5 0.5 0.5],...
    'String',{'0M'},...
    'LineStyle','none',...
    'FontName','Arial',...
    'FontWeight','bold',...
    'FontSize',11,...    
    'FontAngle','italic');

% Create textbox
annotation(figure1,'textbox',...
    [0.44 0.85 0.07 0.06],...
    'Color',[0.5 0.5 0.5],...
    'String',{'1M'},...
    'LineStyle','none',...
    'FontName','Arial',...
    'FontWeight','bold',...
    'FontSize',11,...    
    'FontAngle','italic');

% Create textbox
annotation(figure1,'textbox',...
    [0.31 0.85 0.07 0.06],...
    'Color',[0.5 0.5 0.5],...
    'String',{'4M'},...
    'LineStyle','none',...
    'FontName','Arial',...
    'FontWeight','bold',...
    'FontSize',11,...
    'FontAngle','italic');

% Create textbox
annotation(figure1,'textbox',[0.08 0.807 0.38 0.1],...
    'Color',[0.5 0.5 0.5],...
    'String',{'in GdnHCl solution'},...
    'LineStyle','none',...
    'FontWeight','bold',...
    'FontName','Arial',...
    'FontAngle','italic',...
    'FitBoxToText','off');

annotation(figure1,'textbox',...
    [0.465 0.745 0.28 0.08],...
    'Color',d(1).idclr,...
    'String',{'Control (n=9)'},...
    'FontWeight','bold',...
    'FontSize',12,...
    'EdgeColor','none');

annotation(figure1,'textbox',...
    [0.655 0.46 0.36 0.08],...
    'Color',d(10).idclr,...
    'String',{'Blebbistatin (n=9)'},...
    'FontWeight','bold',...
    'FontSize',12,...
    'EdgeColor','none');

% Create textbox
annotation(figure1,'textbox',...
    [0.14 0.5 0.26 0.08],...
    'Color',d(19).idclr,...
    'String',{'TGF-\beta (n=9)'},...
    'FontWeight','bold',...
    'FontSize',12,...
    'EdgeColor','none');

